$(document).ready(function(){
        var calendar = $('#calendar').fullCalendar({
			
            header:{
                left: 'prev,next today,month,year',
                center: 'title',
				
                right: 'agendaWeek'
            },
            defaultView: 'month',
			initialView: 'resourceTimelineDay',
            editable: true,
			contentHeight: 'auto',
            selectable: true,
            allDaySlot: false,
			
            
            events: "/lorinsentul/model/things-todo/things-todo.php?aksi=view",
   
            
            eventClick:  function(event, jsEvent, view) {
                endtime = $.fullCalendar.moment(event.end).format('hh:mm');
                starttime = $.fullCalendar.moment(event.start).format('dddd, MMMM Do YYYY, hh:mm:ss');
                var mywhen = starttime + ' - ' + endtime;
                $('#modalTitle').html(event.titlea);
                $('#modalWhen').text(mywhen);
                $('#eventID').val(event.id);
                $('#calendarModal').modal();
            }
            
            //header and other values
            
        });
		
		$('#kode_venue').on('change',function(){
			
			var uid = $(this).val();
			alert(uid);
			
			
			});
               
       $('#submitButton').on('click', function(e){
           // We don't want this to act as a link so cancel the link action
           e.preventDefault();
           doSubmit();
       });
       
       $('#deleteButton').on('click', function(e){
           // We don't want this to act as a link so cancel the link action
           e.preventDefault();
           doDelete();
       });
       
       function doDelete(){
           $("#calendarModal").modal('hide');
           var eventID = $('#eventID').val();
           $.ajax({
               url: 'index.php',
               data: 'action=delete&id='+eventID,
               type: "POST",
               success: function(json) {
                   if(json == 1)
                        $("#calendar").fullCalendar('removeEvents',eventID);
                   else
                        return false;
                    
                   
               }
           });
       }
       function doSubmit(){
           $("#createEventModal").modal('hide');
           var title = $('#title').val();
           var startTime = $('#startTime').val();
           var endTime = $('#endTime').val();
           
           $.ajax({
               url: 'index.php',
               data: 'action=add&title='+title+'&start='+startTime+'&end='+endTime,
               type: "POST",
               success: function(json) {
                   $("#calendar").fullCalendar('renderEvent',
                   {
                       id: json.id,
                       title: title,
                       start: startTime,
                       end: endTime,
                   },
                   true);
               }
           });
           
       }
    });