<link href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.0/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.0/js/bootstrap.min.js"></script>
<script src="//code.jquery.com/jquery-1.11.1.min.js"></script>

<table class="table table-striped table-bordered table-condensed tab_logic turf" id="turf">
    <thead>
        <tr class="persist headings">
            <td colspan="3"><a class="toggle" tabindex="997" href="#">Turf Measurements</a>

            </td>
            <td tabindex="998"><a class="toggle" href="#">Show / Hide</a>

            </td>
        </tr>
        <tr class="headings">
            <td class="heading">Turf</td>
            <td class="heading">Length</td>
            <td class="heading">Width</td>
            <td class="heading">Total</td>
        </tr>
        <tr class="grand-total">
            <td>Combined Totals</td>
            <td class="length-total"></td>
            <td class="width-total"></td>
            <td class="table-total"></td>
        </tr>
    </thead>
    <tfoot>
        <tr class="grand-total persist">
            <td>Combined Totals</td>
            <td id="length-grand-total"></td>
            <td id="width-grand-total"></td>
            <td id="table-grand-total"></td>
        </tr>
    </tfoot>
    <tbody>
        <tr id='addr1' class="calculation visible">
            <td>1</td>
            <td class="length">
                <input type="text" class="length form-control input-md" value="" tabindex="1" />
            </td>
            <td class="width">
                <input type="text" class="width form-control input-md" type="text" value="" tabindex="2" />
            </td>
            <td class="row-total">
                <input type="text" class="row-total form-control" value="" readonly />
            </td>
        </tr>
        <tr class="calculation visible">
            <td>2</td>
            <td class="length">
                <input type="text" class="length form-control input-md" value="" tabindex="3" />
            </td>
            <td class="width">
                <input type="text" class="width form-control input-md" value="" tabindex="4" />
            </td>
            <td class="row-total">
                <input type="text" class="row-total form-control" value="" readonly />
            </td>
        </tr>
        <tr id='addr2' class="calculation visible">
    </tbody>
</table>
<div><a id="add_row" class="btn btn-default pull-left"><span class="glyphicon glyphicon-plus-sign"></span>  Add Row</a>

    <div><a class="btn btn-default pull-left calculate" title="calculate row">Calculate</a>

    </div>
</div>
<div><a href="#" id='delete_row' class="pull-right btn btn-default"><span class="glyphicon glyphicon-minus-sign"></span>  Delete Row</a>

</div>
<script>
$(document).ready(function () {
       
    var numRows = 2, ti = 5;

function isNumber(n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
}

function recalc() {
    var lt = 0,
        wt = 0,
        tt = 0;
    $("#turf").find('tr').each(function () {
        var l = $(this).find('input.length').val();
        var w = $(this).find('input.width').val();
        var dateTotal = (l * w);
        $(this).find('input.row-total').val(dateTotal ? dateTotal : "");
        wt += isNumber(w) ? parseInt(w, 10) : 0;
        lt += isNumber(l) ? parseInt(l, 10) : 0;
        tt += isNumber(dateTotal) ? dateTotal : 0;
    }); //END .each
    $("#length-grand-total").html(lt);
    $("#width-grand-total").html(wt);
    $("#table-grand-total").html(tt);
}

function addRow() {

    $('#addr' + numRows).html("<td>" + (numRows + 1) + "</td><td class='length'><input name='length" + numRows + "' type='text' class='length form-control input-md' value='' tabindex='" + (ti++) + "' /></td><td class='width'><input  name='width" + numRows + "' type='text' class='width form-control input-md' value='' tabindex='" + (ti++) + "' /></td><td class='row-total'><input type='text' class='row-total form-control' value='' readonly /></td>");

    $('#turf tr:last').after('<tr id="addr' + (numRows + 1) + '" class="calculation visible"></tr>');
    numRows++;
}

function delRow() {
    if (numRows > 1) {
        $("#addr" + (numRows - 1)).remove();
        numRows--;
    }
}
$(function () {
    $("#turf").on("click", ".calculation", recalc);
    $("#turf").on("keyup blur", ".form-control", recalc);
    $("#turf").on("keyup", ".length:last", function () {
        if (!$(this).data("done")) { // only do this once per field
            $(this).data("done", true);
            addRow();
        }
    });
    $("#add_row").on("click",function() {addRow()});
    $("#delete_row").on("click",function() {delRow()});
});

function calculateSum() {
    var sum = 0;
    //iterate through each textboxes and add the values
    $(".row-total").each(function () {
        //add only if the value is number
        if (!isNaN(this.value) && this.value.length !== 0) {
            sum += parseFloat(this.value);
        }
    });
    //.toFixed() method will roundoff the final sum to 2 decimal places
    $(".table-total").val(sum.toFixed(2));
}

function calculateRow() {

    $('.length, .width').keyup(function () {
        var rowtotal = 0;
        var $row = $(this).closest("tr");
        var length = parseFloat($row.find('.length').val());
        var width = parseFloat($row.find('.width').val());
        rowtotal = length * width;
        alert($("#width").val()); //remove after testing

        if (isNaN(rowtotal)) {
            $row.find('.row-total').val("Missing an Input");
        } else {
            $row.find('.row-total').val(rowtotal);
        }
        calculateSum();
    });
}
  });
//*

</script>